#!/bin/sh

#########################################################
# Script to start/stop syslog-ng test server.
# Configuration needs to pass by environment variables
#   - SYSLOGNG_CLIENT_IP, SYSLOGNG_CLIENT_PORT, SYSLOG_CLIENT_TRANSMODE
#########################################################

FILE_SYSLOGNG_TEST_PID=/var/run/syslogng_test.pid
PATH_SYSLOGNG_CONF=/usr/syno/etc/synosyslog
PATH_SYSLOGNG_TEMPLATE_FOLDER=/usr/syno/syslogclient/etc/template/
FILE_SYNOSYSLOG_TEST_CONF=${PATH_SYSLOGNG_CONF}/testconn.conf

TestConfDataClear(){
    rm ${FILE_SYNOSYSLOG_TEST_CONF}
}
TestConfFolderCreate(){
    echo "not implemented"
}

TestVerProcess(){
    touch ${FILE_SYNOSYSLOG_TEST_CONF}
    echo "@version:3.2.4" >> ${FILE_SYNOSYSLOG_TEST_CONF}
    echo "options { keep_hostname(yes); };" >> ${FILE_SYNOSYSLOG_TEST_CONF}
}
TestSourceProcess(){
    echo 'source s_syno_syslog { unix-stream("/var/run/test"); };' >> ${FILE_SYNOSYSLOG_TEST_CONF}
}
TestDestProcess(){
    if [ "tcp" = "${SYSLOGNG_CLIENT_TRANS_MODE}" ]; then
    	if [ "1" = "${SYSLOGNG_CLIENT_SSL}" ]; then
    	    TEMPLATE_FILE=${PATH_SYSLOGNG_TEMPLATE_FOLDER}/dest_net_enc.template
    	    cat $TEMPLATE_FILE | sed -e "s/__SYSLOG_SERVER_IP__/${SYSLOGNG_CLIENT_IP}/" | sed -e "s/__SYSLOG_SERVER_PORT__/${SYSLOGNG_CLIENT_PORT}/" | sed -e "s=__SYSLOG_SERVER_CA__=${SYSLOGNG_CLIENT_CA_FILE_PATH}=" >> ${FILE_SYNOSYSLOG_TEST_CONF}
    	else
    	    TEMPLATE_FILE=${PATH_SYSLOGNG_TEMPLATE_FOLDER}/dest_net_tcp.template
    	    cat $TEMPLATE_FILE | sed -e "s/__SYSLOG_SERVER_IP__/${SYSLOGNG_CLIENT_IP}/" | sed -e "s/__SYSLOG_SERVER_PORT__/${SYSLOGNG_CLIENT_PORT}/" >> ${FILE_SYNOSYSLOG_TEST_CONF}
    	fi
    else
    	TEMPLATE_FILE=${PATH_SYSLOGNG_TEMPLATE_FOLDER}/dest_net_udp.template
    	cat $TEMPLATE_FILE | sed -e "s/__SYSLOG_SERVER_IP__/${SYSLOGNG_CLIENT_IP}/" | sed -e "s/__SYSLOG_SERVER_PORT__/${SYSLOGNG_CLIENT_PORT}/" >> ${FILE_SYNOSYSLOG_TEST_CONF}
    fi
}
TestLogProcess(){
    echo "log { source(s_syno_syslog); destination(d_syno_internet); flags(flow_control); };" >> ${FILE_SYNOSYSLOG_TEST_CONF}
}

CheckIfDaemonAlive(){
    PROCESS_ALIVE=0
    if [ -f "$1" ]; then
	PROCESS_PID=`cat $1`
	kill -0 ${PROCESS_PID}
        if [ "0" = "$?" ]; then
    	    PROCESS_ALIVE=1
    	fi
    fi
}

TestSyslogngStart(){
    /sbin/syslog-ng --module-path=/lib/syslogmod --pidfile=${FILE_SYSLOGNG_TEST_PID} --cfgfile=${FILE_SYNOSYSLOG_TEST_CONF} --persist-file="/tmp/syslog-ng-test.persist" --control="/tmp/syslog-ng-test.ctl"
}
TestSyslogngStop(){
    CheckIfDaemonAlive ${FILE_SYSLOGNG_TEST_PID}
    if [ "1" = "$PROCESS_ALIVE" ]; then
        kill ${PROCESS_PID}
        sleep 1;
    fi

    TestConfDataClear;
}

case $1 in
    start)
    	echo "Syslog-ng test server start..."
        TestConfDataClear;
        #TestConfFolderCreate;

        TestVerProcess;    
        TestSourceProcess;
    	TestDestProcess;
    	TestLogProcess;

        TestSyslogngStart;
    ;;
    stop)
        echo "Syslog-ng test server stop..."
        TestSyslogngStop;
    ;;
    *)
    	echo "Usage: $0 start|stop"
    ;;
esac
