/*var synoDuplicateFileData = [
	[ '1', 'public', '/volume1/public/aa', 1024, 1353491284 ],
	[ '2', 'music',  '/volume1/music/bb',  2048, 1353491284 ],
	[ '3', 'video',  '/volume1/video/vv',  4096, 1353491284 ]
];*/

function DuplicateFile()
{
    Ext.QuickTips.init();

	if(typeof synoDuplicateFileData === 'undefined' || synoDuplicateFileData.length === 0) {
		NoDataSet('duplicate_file_nodata');
		return ;
	}
    // NOTE: This is an example showing simple state management. During development,
    // it is generally best to disable state management as dynamically-generated ids
    // can change across page loads, leading to unpredictable results.  The developer
    // should ensure that stable state ids are set for stateful components in real apps.    
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

    var store = new Ext.data.ArrayStore({
        fields: [
           {name: 'Group'},
           {name: 'Share'},
           {name: 'File'},
           {name: 'Size', type: 'int'},
           {name: 'Time', type: 'date', dateFormat:'U'}
        ]
    });

    // manually load local data
    store.loadData(synoDuplicateFileData);

    // create the Grid
    var grid = new Ext.grid.GridPanel({
		border: false,
        store: store,
		stripeRows: true,
        width: 930,
		enableColumnResize: false,
		enableHdMenu: false,
		enableColumnHide: false,
		enableColumnMove: false,
		viewConfig: GridViewConfig,
        columns: [
            {
				header   : _T('report','reportUI_title_group'),
                width    : 80,
                sortable : true,
				tooltip  : _T('report','reportUI_title_group'),
                dataIndex: 'Group'
            },
            {
                header   : _T('report','reportUI_title_share'),
                width    : 150,
                sortable : true,
                dataIndex: 'Share',
				tooltip  : _T('report','reportUI_title_share'),
				css: 'font-weight: bold;'
            },
            {
				header   : _T('common','file'),
                width    : 350,
                sortable : true,
                dataIndex: 'File',
				tooltip  : _T('common','file'),
                renderer: htmlEncodeRenderer
            },
            {
                header   : _T('common','size'),
                width    : 150,
                sortable : true,
				tooltip  : _T('common','size'),
                renderer : SizeUnit,
                dataIndex: 'Size'
            },
            {
				header   : _T('report', 'reportUI_title_modify_time'),
                width    : 200,
                sortable : true,
				tooltip  : _T('report', 'reportUI_title_modify_time'),
				renderer: Ext.util.Format.dateRenderer('Y-m-d H:i:s'),
                dataIndex: 'Time'
            }
        ],
        plugins: [ new GridPanelPlugin(14) ]
    });

    // render the grid to the specified div in the page
    grid.render('duplicate_file');
}
