#!/bin/sh
CUPSD_NAME=cupsd
GCPD_NAME=gcpd
GCPD=/usr/syno/sbin/$GCPD_NAME
LOGGER=/usr/bin/logger
SLEEP=/bin/sleep
PIDOF=/bin/pidof
KILLALL=/usr/bin/killall

log_msg()
{
	$LOGGER -sp $1 -t GCP "$2"
}

WaitProcDead() {
        i=0
        while [ $i -lt 40 ] ; do
                $PIDOF $1 > /dev/null 2>&1
                Ret=$?
                if [ $Ret -eq 1 ] ; then
                        break;
                fi
                $SLEEP 1
                i=`expr $i + 1`
        done
}


start_gcpd()
{
	if /bin/pidof $CUPSD_NAME >/dev/null; then
		
		if $PIDOF $GCPD_NAME; then
			log_msg info "gcpd is already running"
		else
			log_msg info "start gcpd.."
			$GCPD
		fi
	else
		log_msg info "cupsd not running, skip start gcpd"
	fi
}

sighup_gcpd()
{
	if $PIDOF $GCPD_NAME; then
		log_msg info "SIGHUP gcpd"
		$KILLALL -SIGHUP $GCPD_NAME
	else
		start_gcpd
	fi
}

stop_gcpd() 
{
    	if $PIDOF $GCPD_NAME; then
		log_msg info "Stopping gcpd..."
		$KILLALL $GCPD_NAME
		WaitProcDead $GCPD_NAME
	else
		log_msg info "gcpd is not running. stop nothing."
	fi
}

case $1 in
start)
	start_gcpd
	exit 0
	;;
stop)	
	stop_gcpd
	exit 0
	;;
restart)	
	stop_gcpd
	$SLEEP 1
	start_gcpd
	exit 0
	;;
reload)
	sighup_gcpd
	exit 0
	;;
*)
	/bin/echo "usage: $0 { start | stop | restart }" >&2
	exit 1
	;;
esac
# the return value should be 0 if operation success without a hitch
