#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

. /etc.defaults/rc.subr

STORAGED_NAME='synostoraged'
STORAGED='/usr/syno/sbin/synostoraged'
STORAGE_TOOL='/usr/syno/sbin/synostorage'
STORAGEPidFile='/var/run/synostoraged.pid'
CheckHotspare='/usr/syno/bin/synocheckhotspare'
SupportHotSpare=`/bin/get_key_value /etc.defaults/synoinfo.conf support_hotspare`

IsPidRunning() 
{
        if [ -f "$1" ]; then
                /bin/kill -0 `cat $1` >/dev/null 2>&1
                if [ $? = 0 ]; then
                        return 1;
                fi
        fi
        return 0;
}

StartSTORAGED()
{
    if [ -x "${STORAGED}" ]; then
	    echo "Start STORAGE Daemon....."
	    ${STORAGED}
    else
	    echo "${STORAGED} is not executable."
    fi
}

IsSTORAGEDAlive()
{
    IsPidRunning ${STORAGEPidFile}
    if [ $? -eq 1 ] ; then
	    return $LSB_STAT_RUNNING
    else
	    return $LSB_STAT_NOT_RUNNING
    fi
}

case "$1" in

stop)
	echo "Stop STORAGE Daemon..."
	/bin/kill -9 `cat ${STORAGEPidFile}`
	;;

start)
	if [ "xyes" != "x${SupportHotSpare}" ]; then
	    echo "HotSpare is not supported. Skip running Storage Daemon"
	    exit 0
	fi
		${CheckHotspare}
        cHotSpareDisk=`${STORAGE_TOOL} --hotspare -c`
        if [ $cHotSpareDisk -eq 0 ];then
	    echo "No HotSpare Disk exist. Skip running Storage Daemon..."
	    exit 0
        fi

        IsSTORAGEDAlive
        if [ $? = $LSB_STAT_RUNNING ]; then
	    echo "Storage Daemon is already running..."
	    exit 0
        fi

	StartSTORAGED
	;;
	
restart)
	$0 stop
	sleep 1
	$0 start
	;;
status)
	IsSTORAGEDAlive
	return $?
	;;
*)
	echo "usage: $0 { start | stop | restart | status}" >&2
        exit 1
        ;;
	                        
esac
