#!/bin/sh
# Copyright (c) 2000-2007 Synology Inc. All rights reserved.
KERNEL_VERSION=`uname -r`

CheckProcDead() {
	killall $1 > /dev/null 2>&1

	count=5
	while [ $count -gt 0 ]; do
		pidof $1 > /dev/null 2>&1
		if [ $? -ne 0 ]; then
			return 0
		fi
		sleep 1
		killall $1 > /dev/null 2>&1
		count=`expr $count - 1`
	done
}

SYNOMKFLVD="/usr/syno/sbin/synomkflvd"

case $1 in
	start)
		Support=`/bin/get_key_value /etc.defaults/synoinfo.conf supportvideostation`
		case "$Support" in
		[Yy][Ee][Ss])
			;;
		*)
			echo "Video Station service is not support. Skip..."
			exit;
			;;
		esac

		echo "Starting Synology Make FLV Daemon ..."
		case "$KERNEL_VERSION" in
		"2.4.22-uc0" | "2.6.15" | "2.6.24")
			sleep 180 && $SYNOMKFLVD &
			;;
		*)
			$SYNOMKFLVD
			;;
		esac

	;;
	stop)
		echo "Stopping Synology Make FLV Daemon ..."

		#To ensure that mkflv is dead before volume removed
		CheckProcDead synomkflvd
		CheckProcDead synoflvconv
		CheckProcDead ffmpeg
		;;
	restart)
		$0 stop
		sleep 1
		$0 start
		;;
	*)
		echo "Usage: $0 start|stop|restart"
	;;
esac

