#!/bin/sh

#Conf dir/file definition
PATH_SYSLOGNG_PKG_DIR=/var/packages/SyslogServer/target
PATH_SYSLOGNG_BIN_FOLDER=${PATH_SYSLOGNG_PKG_DIR}/sbin
PATH_SYSLOGNG_TEMPLATE_FOLDER=${PATH_SYSLOGNG_PKG_DIR}/etc/template
FILE_SYNOSYSLOG_SQL=${PATH_SYSLOGNG_PKG_DIR}/scripts/loginfo.sql

PATH_SYSLOGNG_CONF=/usr/syno/etc/synosyslog
PATH_SYSLOGNG_CONF_FOLDER=${PATH_SYSLOGNG_CONF}/syslog.d
FILE_SYSLOGNG_SETTING=/var/packages/SyslogServer/etc/setting.conf
FILE_SYSLOGNG_PID=/var/run/syslogng.pid
FILE_SYSLOGD_PID=/var/run/syslogd.pid
FILE_LOGMONI_PID=/var/run/logmonitord.pid
FILE_SYSLOGMAIL_PID=/var/run/syslogmaild.pid
FILE_SYNOSYSLOG_CONF=${PATH_SYSLOGNG_CONF_FOLDER}/syno.conf

#Global variables
SYSLOGNG_SERVER_ENABLE=0
SYSLOGNG_SERVER_PORT=1234
SYSLOGNG_SERVER_TRANS_MODE=tcp
SYSLOGNG_SERVER_SSL=0
SYSLOGNG_SERVER_LOG_ROTATE_TIME=0
SYSLOGNG_SERVER_MAIL_ENABLE=0
SYSLOGNG_SERVER_MAIL_FILETER=""
SYSLOGNG_SERVER_DB_LOC=""
SYSLOGNG_SERVER_DB_PATH=""
SYSLOGNG_SERVER_CA_KEY_PATH="/usr/syno/etc/ssl/ssl.key/server.key"
SYSLOGNG_SERVER_CA_FILE_PATH="/usr/syno/etc/ssl/ssl.crt/server.crt"
SYSLOGNG_SERVER_INTER_FILETER=""

PROCESS_ALIVE=0
PROCESS_PID=0

###########################################################################
# Syslog Client part
###########################################################################

FILE_SYSLOGNG_CLIENT_SETTING=/etc/synosyslog.conf
PATH_SYSLOGNG_CLIENT_CONFIG_FOLDER=/usr/syno/syslogclient/etc
PATH_SYSLOGNG_CLIENT_TEMPLATE_FOLDER=/usr/syno/syslogclient/etc/template
PATH_SYSLOGNG_CLINET_CONF_FOLDER=${PATH_SYSLOGNG_CONF}/client
FILE_SYNOSYSLOG_CLIENT_CONF=${PATH_SYSLOGNG_CLINET_CONF_FOLDER}/syno.conf

SYSLOGNG_CLIENT_ENABLE=0
SYSLOGNG_CLIENT_IP=""
SYSLOGNG_CLIENT_PORT=1234
SYSLOGNG_CLIENT_TRANS_MODE=tcp
SYSLOGNG_CLIENT_SSL=0
SYSLOGNG_CLIENT_FAC_FILTER=""
SYSLOGNG_CLIENT_SEV_FILTER=""

SyslogClientSettingGet(){
    #Copy syslog system conf (share same system.conf with Syslog Server)
    cp -rf ${PATH_SYSLOGNG_CLIENT_CONFIG_FOLDER}/system.conf ${PATH_SYSLOGNG_CONF}

    if [ -f "${FILE_SYSLOGNG_CLIENT_SETTING}" ]; then
        SYSLOGNG_CLIENT_ENABLE=`/bin/get_key_value ${FILE_SYSLOGNG_CLIENT_SETTING} server_enable`
        SYSLOGNG_CLIENT_IP=`/bin/get_key_value ${FILE_SYSLOGNG_CLIENT_SETTING} server_addr`
        SYSLOGNG_CLIENT_PORT=`/bin/get_key_value ${FILE_SYSLOGNG_CLIENT_SETTING} server_port`
        SYSLOGNG_CLIENT_TRANS_MODE=`/bin/get_key_value ${FILE_SYSLOGNG_CLIENT_SETTING} server_trans`
        SYSLOGNG_CLIENT_SSL=`/bin/get_key_value ${FILE_SYSLOGNG_CLIENT_SETTING} server_ssl`
        SYSLOGNG_CLIENT_FAC_FILTER=`/bin/get_key_value ${FILE_SYSLOGNG_CLIENT_SETTING} server_facfilter`
        SYSLOGNG_CLIENT_SEV_FILTER=`/bin/get_key_value ${FILE_SYSLOGNG_CLIENT_SETTING} server_sevfilter`
        SYSLOGNG_CLIENT_CA_FILE_PATH=`/bin/get_key_value ${FILE_SYSLOGNG_CLIENT_SETTING} server_ca_path`
    else
        echo "Syslog client setting file does not exist!";
        exit 1;
    fi
}

ClientConfDataClear(){
    rm -rf ${PATH_SYSLOGNG_CLINET_CONF_FOLDER} > /dev/null 2>&1
}

ClientConfFolderCreate(){
    mkdir -p ${PATH_SYSLOGNG_CLINET_CONF_FOLDER}
}

ClientSourceProcess(){
    touch ${FILE_SYNOSYSLOG_CLIENT_CONF}

    TEMPLATE_FILE=${PATH_SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/src_socket.template
    cat $TEMPLATE_FILE >> ${FILE_SYNOSYSLOG_CLIENT_CONF}
}
ClientFilterProcess(){
    #Facility filter
    SYSLOGNG_FAC_FILTER_LIST=`echo ${SYSLOGNG_CLIENT_FAC_FILTER} | sed 's/,/ /g'`
    SYSLOGNG_FAC_FILTER_STRING=""
    FAC_STRING=""
    for fac in $SYSLOGNG_FAC_FILTER_LIST 
    do
    	if [ -n "${fac}" ]; then
    	    if [ -z "${SYSLOGNG_FAC_FILTER_STRING}" ]; then
    		    SYSLOGNG_FAC_FILTER_STRING="program(${fac} type(\"string\"))"
    	    else
    		    SYSLOGNG_FAC_FILTER_STRING="${SYSLOGNG_FAC_FILTER_STRING} or program(${fac} type(\"string\"))"
    	    fi
    	fi
    done

    if [ "" = "${SYSLOGNG_FAC_FILTER_STRING}" ]; then
        SYSLOGNG_FAC_FILTER_STRING="program(no_fac)"
    fi

    TEMPLATE_FILE=${PATH_SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/filter_fac.template
    cat $TEMPLATE_FILE | sed -e "s/__SYSLOG_FAC_FILTER__/${SYSLOGNG_FAC_FILTER_STRING}/" >> ${FILE_SYNOSYSLOG_CLIENT_CONF}

    #Severity filter
    SYSLOGNG_SEV_FILTER_LIST=`echo ${SYSLOGNG_CLIENT_SEV_FILTER} | sed 's/,/ /g'`
    SYSLOGNG_SEV_FILTER_STRING=""
    PRIO_STRING=""
    for prio in $SYSLOGNG_SEV_FILTER_LIST 
    do
    	if [ -n "${prio}" ]; then
            if [ "error" = "${prio}" ]; then
                PRIO_STRING="emerg,alert,crit,err"
            elif [ "warning" = "${prio}" ]; then
                PRIO_STRING="warning"
            elif [ "info" = "${prio}" ]; then
                PRIO_STRING="notice,info"
            fi

    	    if [ -z ${SYSLOGNG_SEV_FILTER_STRING} ]; then
    		    SYSLOGNG_SEV_FILTER_STRING="${PRIO_STRING}"
    	    else
    		    SYSLOGNG_SEV_FILTER_STRING="${SYSLOGNG_SEV_FILTER_STRING},${PRIO_STRING}"
    	    fi
    	fi
    done

    TEMPLATE_FILE=${PATH_SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/filter_sev.template
    cat $TEMPLATE_FILE | sed -e "s/__SYSLOG_SEV_FILTER__/${SYSLOGNG_SEV_FILTER_STRING}/" >> ${FILE_SYNOSYSLOG_CLIENT_CONF}
}
ClientDestProcess(){
    if [ "tcp" = "${SYSLOGNG_CLIENT_TRANS_MODE}" ]; then
    	if [ "1" = "${SYSLOGNG_CLIENT_SSL}" ]; then
    	    TEMPLATE_FILE=${PATH_SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/dest_net_enc.template
    	    cat $TEMPLATE_FILE | sed -e "s/__SYSLOG_SERVER_IP__/${SYSLOGNG_CLIENT_IP}/" | sed -e "s/__SYSLOG_SERVER_PORT__/${SYSLOGNG_CLIENT_PORT}/" | sed -e "s=__SYSLOG_SERVER_CA__=${SYSLOGNG_CLIENT_CA_FILE_PATH}=" >> ${FILE_SYNOSYSLOG_CLIENT_CONF}
    	else
    	    TEMPLATE_FILE=${PATH_SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/dest_net_tcp.template
    	    cat $TEMPLATE_FILE | sed -e "s/__SYSLOG_SERVER_IP__/${SYSLOGNG_CLIENT_IP}/" | sed -e "s/__SYSLOG_SERVER_PORT__/${SYSLOGNG_CLIENT_PORT}/" >> ${FILE_SYNOSYSLOG_CLIENT_CONF}
    	fi
    else
    	TEMPLATE_FILE=${PATH_SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/dest_net_udp.template
    	cat $TEMPLATE_FILE | sed -e "s/__SYSLOG_SERVER_IP__/${SYSLOGNG_CLIENT_IP}/" | sed -e "s/__SYSLOG_SERVER_PORT__/${SYSLOGNG_CLIENT_PORT}/" >> ${FILE_SYNOSYSLOG_CLIENT_CONF}
    fi
}
ClientLogProcess(){
    TEMPLATE_FILE=${PATH_SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/log_socket_to_net.template
    cat $TEMPLATE_FILE >> ${FILE_SYNOSYSLOG_CLIENT_CONF}
}
ClientOptionProcess(){
    TEMPLATE_FILE=${PATH_SYSLOGNG_CLIENT_TEMPLATE_FOLDER}/option.template
    cat $TEMPLATE_FILE >> ${FILE_SYNOSYSLOG_CLIENT_CONF}
}
###########################################################################
# End of Syslog Client part
###########################################################################

SyslogSettingGet(){
    if [ -f "${FILE_SYSLOGNG_SETTING}" ]; then
    	SYSLOGNG_SERVER_ENABLE=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_enable`
    	SYSLOGNG_SERVER_PORT=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_port`
    	SYSLOGNG_SERVER_TRANS_MODE=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_trans`
    	SYSLOGNG_SERVER_SSL=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_ssl`
    	SYSLOGNG_SERVER_LOG_ROTATE_TIME=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_log_rotate_time`
    	SYSLOGNG_SERVER_MAIL_ENABLE=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_enable_mail`
    	SYSLOGNG_SERVER_MAIL_FILETER=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_mail_filter`
    	SYSLOGNG_SERVER_DB_LOC=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_db_loc`
    	SYSLOGNG_SERVER_DB_PATH=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_db_path`
    	SYSLOGNG_SERVER_CA_KEY_PATH=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_ca_key`
    	SYSLOGNG_SERVER_CA_FILE_PATH=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_ca_file`
    	SYSLOGNG_SERVER_INTER_FILETER=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_internal_filter`
    else
    	echo "Syslog setting file does not exist!";
    	# Server configuration may not exist (Syslog Server package is never installed)
    fi
}

CheckIfDaemonAlive(){
    PROCESS_ALIVE=0
    if [ -f "$1" ]; then
	    PROCESS_PID=`cat $1`
	kill -0 ${PROCESS_PID}
        if [ "0" = "$?" ]; then
    	    PROCESS_ALIVE=1
    	fi
    fi
}

SourceProcess(){
    #Copy syslog system conf
    cp -rf ${PATH_SYSLOGNG_CLIENT_CONFIG_FOLDER}/system.conf ${PATH_SYSLOGNG_CONF}

    if [ "tcp" = "${SYSLOGNG_SERVER_TRANS_MODE}" ]; then
    	if [ "1" = "${SYSLOGNG_SERVER_SSL}" ]; then
    	    TEMPLATE_FILE=${PATH_SYSLOGNG_TEMPLATE_FOLDER}/src_net_enc.template
    	    cat $TEMPLATE_FILE | sed -e "s/__SYNO_PORT__/${SYSLOGNG_SERVER_PORT}/" | sed -e "s=__SYNO_CA_KEY_PATH__=${SYSLOGNG_SERVER_CA_KEY_PATH}=" | sed -e "s=__SYNO_CA_FILE_PATH__=${SYSLOGNG_SERVER_CA_FILE_PATH}=" >> ${FILE_SYNOSYSLOG_CONF}
    	else
    	    TEMPLATE_FILE=${PATH_SYSLOGNG_TEMPLATE_FOLDER}/src_net.template
    	    cat $TEMPLATE_FILE | sed -e "s/__SYNO_PORT__/${SYSLOGNG_SERVER_PORT}/" >> ${FILE_SYNOSYSLOG_CONF}
    
    	fi
    else
    	TEMPLATE_FILE=${PATH_SYSLOGNG_TEMPLATE_FOLDER}/src_net_udp.template
    	cat $TEMPLATE_FILE | sed -e "s/__SYNO_PORT__/${SYSLOGNG_SERVER_PORT}/" >> ${FILE_SYNOSYSLOG_CONF}
    fi
}

MailDestProcess(){
    if [ "1" != "${SYSLOGNG_SERVER_MAIL_ENABLE}" ]; then
	    return;
    fi 
    
    cat ${PATH_SYSLOGNG_TEMPLATE_FOLDER}/dest_mail.template >> ${FILE_SYNOSYSLOG_CONF}
}

DestProcess(){
    cat ${PATH_SYSLOGNG_TEMPLATE_FOLDER}/dest_db.template | sed -e "s=__SYNO_DB_PATH__=${LOGDB_PATH}=" >> ${FILE_SYNOSYSLOG_CONF}
    MailDestProcess;
}

MailLogProcess(){
    if [ "1" != "${SYSLOGNG_SERVER_MAIL_ENABLE}" ]; then
	    return;
    fi
 
    if [ ! -z "${SYSLOGNG_PRIOR_STRING}" ]; then
	    cat ${PATH_SYSLOGNG_TEMPLATE_FOLDER}/log_send_mail.template | sed -e "s=_SYNO_FILTER_=filter(f_syno_mail);=g" >> ${FILE_SYNOSYSLOG_CONF}
    else
	    cat ${PATH_SYSLOGNG_TEMPLATE_FOLDER}/log_send_mail.template | sed -e "s/_SYNO_FILTER_//g" >> ${FILE_SYNOSYSLOG_CONF}
    fi

}

NetLogProcess(){
    cat ${PATH_SYSLOGNG_TEMPLATE_FOLDER}/log_net_to_db.template >> ${FILE_SYNOSYSLOG_CONF}
}

LogProcess(){
    NetLogProcess;
    MailLogProcess;
}

MailFilterProcess(){
    if [ "1" != "${SYSLOGNG_SERVER_MAIL_ENABLE}" ]; then
	    return;
    fi 

    #1. Get mail level setting from setting.conf
    #2. Compose of filter string for syslog-ng
    #3. Generate log conf file for mailing
    SYSLOGNG_PRIOR_LIST=`echo ${SYSLOGNG_SERVER_MAIL_FILETER} | sed 's/,/ /g'`
    SYSLOGNG_PRIOR_STRING=""
    for prio in $SYSLOGNG_PRIOR_LIST 
    do
    	if [ ! -z "${prio}" ]; then
    	    if [ -z ${SYSLOGNG_PRIOR_STRING} ]; then
    		    SYSLOGNG_PRIOR_STRING="${prio}"
    	    else
    		    SYSLOGNG_PRIOR_STRING="${SYSLOGNG_PRIOR_STRING},${prio}"
    	    fi
    	fi
    done
    
    if [ ! -z ${SYSLOGNG_PRIOR_STRING} ]; then
	    cat ${PATH_SYSLOGNG_TEMPLATE_FOLDER}/filter_prior_mail.template | sed -e "s/_SYNO_PRIORITY_/${SYSLOGNG_PRIOR_STRING}/g" >> ${FILE_SYNOSYSLOG_CONF}
    fi
}

InternalFilterProcess(){
    #1. Get internal level setting from setting.conf
    #2. Compose of filter string for syslog-ng
    #3. Generate log conf file for mailing
    SYSLOGNG_INTERNAL_PRIOR_LIST=`echo ${SYSLOGNG_SERVER_INTER_FILETER} | sed 's/,/ /g'`
    SYSLOGNG_INTERNAL_PRIOR_STRING=""
    for prio in $SYSLOGNG_INTERNAL_PRIOR_LIST 
    do
    	if [ -n "${prio}" ]; then
    	    if [ -z ${SYSLOGNG_INTERNAL_PRIOR_STRING} ]; then
    		    SYSLOGNG_INTERNAL_PRIOR_STRING="${prio}"
    	    else
    		    SYSLOGNG_INTERNAL_PRIOR_STRING="${SYSLOGNG_INTERNAL_PRIOR_STRING},${prio}"
    	    fi
    	fi
    done
    
    if [ -n ${SYSLOGNG_INTERNAL_PRIOR_STRING} ]; then
	    cat ${PATH_SYSLOGNG_TEMPLATE_FOLDER}/filter_prior_internal.template | sed -e "s/_SYNO_PRIORITY_/${SYSLOGNG_INTERNAL_PRIOR_STRING}/g" >> ${FILE_SYNOSYSLOG_CONF}
    fi
}

FilterProcess(){
    InternalFilterProcess;
    MailFilterProcess;
}

# Service control
SyslogngStart(){
    /sbin/syslog-ng --module-path=/lib/syslogmod --pidfile=${FILE_SYSLOGNG_PID} --cfgfile=${PATH_SYSLOGNG_CONF}/system.conf --persist-file="/tmp/syslog-ng.persist" --control="/tmp/syslog-ng.ctl"
}
SyslogngStop(){
    CheckIfDaemonAlive ${FILE_SYSLOGNG_PID}
    if [ "1" = "$PROCESS_ALIVE" ]; then
        kill ${PROCESS_PID}
        sleep 1;
    fi
}

LogMoniStart(){
    ${PATH_SYSLOGNG_BIN_FOLDER}/logmonitord
}
LogMoniStop(){
    CheckIfDaemonAlive ${FILE_LOGMONI_PID}
    if [ "1" = "$PROCESS_ALIVE" ]; then
        kill ${PROCESS_PID}
        sleep 1;
    fi
}

LogMailStart(){
    ${PATH_SYSLOGNG_BIN_FOLDER}/syslogmaild
}
LogMailStop(){
    CheckIfDaemonAlive ${FILE_SYSLOGMAIL_PID}
    if [ "1" = "$PROCESS_ALIVE" ]; then
        kill ${PROCESS_PID}
        sleep 1;
    fi
}

ConfDataClear(){
    rm -rf ${PATH_SYSLOGNG_CONF_FOLDER} > /dev/null 2>&1
}

ConfFolderCreate(){
    mkdir -p ${PATH_SYSLOGNG_CONF_FOLDER}
}

ShareExistCheck(){
    SHARE_EXIST=0
    SHARE_PATH=`/usr/syno/sbin/synoshare --get "${SYSLOGNG_SERVER_DB_LOC}" | grep "Path ......" | sed -e 's/^.*\[\(.*\)\]/\1/g'`
    if [ -n "${SHARE_PATH}" ]; then
        SHARE_EXIST=1
        LOGDB_PATH="${SHARE_PATH}/.SYNOSYSLOGDB"
        if [ -d "${SHARE_PATH}" ]; then
            if [ "$LOGDB_PATH" = "$SYSLOGNG_SERVER_DB_PATH" ]; then
                if [ ! -f "$SYSLOGNG_SERVER_DB_PATH" ]; then
                    /usr/syno/bin/sqlite3 "$SYSLOGNG_SERVER_DB_PATH" < "$FILE_SYNOSYSLOG_SQL" > /dev/null 2>&1
                fi
            fi
        fi
    fi
    
    LOGDB_PATH="$SYSLOGNG_SERVER_DB_PATH"
}

ProcessServerConfig() {
    ConfDataClear;
    ConfFolderCreate;
    SourceProcess;
    FilterProcess;
    DestProcess;
    LogProcess;
}

ProcessClientConfig() {
    ClientConfDataClear;
    ClientConfFolderCreate;
    ClientSourceProcess;
    ClientFilterProcess;
    ClientDestProcess;
    ClientLogProcess;
    ClientOptionProcess;
}

#At begining, acquire all server settings
SyslogSettingGet;

#At begining, acquire all client settings
SyslogClientSettingGet;

case $1 in
    start)
    	echo "Syslog-ng server start..."

        #Service enable check
        if [ "yes" != "${SYSLOGNG_SERVER_ENABLE}" -a "yes" != "${SYSLOGNG_CLIENT_ENABLE}" ]; then
            echo "Client/Server is both disabled"
            return;
        fi

        #Restart syslog-ng daemon
        SyslogngStop;

        #Process server config if enabled
        if [ "yes" == "${SYSLOGNG_SERVER_ENABLE}" ]; then
            #Storage check
            ShareExistCheck;
    		if [ "0" = "${SHARE_EXIST}" ]; then 
    			logger -p 3 "Syslog-ng has no usable share!"
    		fi

            #Process configuration for Syslog Server
    		ProcessServerConfig;
        else
            #Make sure config is clear
            ConfDataClear;
            ConfFolderCreate;
        fi

        #Process client config if enabled
        if [ "yes" == "${SYSLOGNG_CLIENT_ENABLE}" ]; then
            #Process configuration for Syslog Client
            ProcessClientConfig;
        else
            #Make sure config is clear
            ClientConfDataClear;
            ClientConfFolderCreate;
        fi
    
        #Start syslog-ng daemon
        SyslogngStart;

        if [ "yes" == "${SYSLOGNG_SERVER_ENABLE}" ]; then
            #Restart log monitor daemon
    		LogMoniStop;
    		LogMoniStart;
    
    		#Restart log mail daemon
    		LogMailStop;
    		LogMailStart;
        fi
    ;;
    stop)
        echo "Syslog-ng server restart by configuration..."
        #Service enable check
        if [ "yes" != "${SYSLOGNG_SERVER_ENABLE}" -a "yes" != "${SYSLOGNG_CLIENT_ENABLE}" ]; then
            #Server/Client are all disabled, stop syslog-ng daemon
            #Invoke hardstop
            $0 hardstop
        elif [ "yes" != "${SYSLOGNG_SERVER_ENABLE}" ]; then
            #Syslog Server is disabled
            ConfDataClear;
            ConfFolderCreate;

            #Invoke restart
            $0 restart
        elif [ "yes" != "${SYSLOGNG_CLIENT_ENABLE}" ]; then
            #Client is disabled
            ClientConfDataClear;
            ClientConfFolderCreate;

            #Invoke restart
            $0 restart
        fi
    ;;
    hardstop)
        echo "Syslog-ng server stop..."

        #Stop syslog-ng daemon
    	SyslogngStop;
    
    	#Stop log monitor daemon
    	LogMoniStop;
    
    	#Stop log mail daemon
    	LogMailStop;

    	#Clear configuration
    	ConfDataClear;
        ClientConfDataClear;
    ;;
    restart)
        echo "Syslog-ng server restart..."

        #Process server config if enabled
        if [ "yes" == "${SYSLOGNG_SERVER_ENABLE}" ]; then
            ShareExistCheck;
    	    if [ "0" = "${SHARE_EXIST}" ]; then 
    		    logger -p 3 "Syslog-ng has no usable share!"
    	    fi

            ProcessServerConfig;
        fi

        #Process client config if enabled
        if [ "yes" == "${SYSLOGNG_CLIENT_ENABLE}" ]; then
            ProcessClientConfig;
        fi

        #Hup syslog-ng daemon
        CheckIfDaemonAlive ${FILE_SYSLOGNG_PID};
        if [ "1" = "${PROCESS_ALIVE}" ]; then
            kill -HUP ${PROCESS_PID}
        else
            SyslogngStart; 
        fi

    	if [ "yes" == "${SYSLOGNG_SERVER_ENABLE}" ]; then
            #Hup log monitor daemon
    	    CheckIfDaemonAlive ${FILE_LOGMONI_PID}	
    	    if [ "1" = "${PROCESS_ALIVE}" ]; then
    		    kill -HUP ${PROCESS_PID}
    	    else
    		    LogMoniStart;
    	    fi

    	    #Hup mail daemon
    	    CheckIfDaemonAlive ${FILE_SYSLOGMAIL_PID}	
    	    if [ "1" = "${PROCESS_ALIVE}" ]; then
        		kill ${PROCESS_PID}
        		sleep 1;
    	    fi
    	    if [ "1" == ${SYSLOGNG_SERVER_MAIL_ENABLE} ]; then
    		    LogMailStart;
    	    fi
        fi
    ;;
    *)
    	echo "Usage: $0 start|stop|hardstop|restart"
    ;;
esac