#!/bin/sh
#
# Startup script for openvpn client
#

CONF_DIR="/usr/syno/etc/synovpnclient/openvpn"
OPENVPN_CONF="$2"
KERNEL_MODULES="x_tables.ko ip_tables.ko iptable_filter.ko nf_conntrack.ko nf_defrag_ipv4.ko nf_conntrack_ipv4.ko nf_nat.ko iptable_nat.ko ipt_REDIRECT.ko xt_multiport.ko xt_tcpudp.ko xt_state.ko ipt_MASQUERADE.ko tun.ko"
SERVICE="ovpnc"

reverse_modules() {
	local modules=$1
	local mod
	local ret=""

	for mod in $modules; do
	    ret="$mod $ret"
	done

	echo $ret
}

unload_module() {
	local modules=`reverse_modules "${KERNEL_MODULES}"`
	/usr/syno/bin/iptablestool --rmmod $SERVICE $modules
}

case "$1" in
  start)
	echo 1 > /proc/sys/net/ipv4/ip_forward

	# Make device if not present (not devfs)
	if [ ! -c /dev/net/tun ]; then
  		# Make /dev/net directory if needed
  		if [ ! -d /dev/net ]; then
        		mkdir -m 755 /dev/net
  		fi
  		mknod /dev/net/tun c 10 200
	fi

	/usr/syno/bin/iptablestool --insmod $SERVICE ${KERNEL_MODULES}

        echo "Starting openvpn client..."
	/usr/sbin/openvpn --daemon --cd ${CONF_DIR} --config ${OPENVPN_CONF} 

        ;;
  stop)
        echo "Stopping openvpn client..."
        if [ -n "`/bin/pidof openvpn`" ]; then
    		/usr/bin/killall openvpn 2>/dev/null
	fi

	sleep 2	
	unload_module;
	;;
  unload)
	unload_module;
	;;
  *)
        echo "Usage: $0 {start conf|stop}"
        exit 1
esac

exit 0

# [EOF]

