#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

HEARTBEAT="/usr/syno/sbin/heartbeatd"
DDNS="/usr/syno/sbin/ddnsd"
CONF="/etc.defaults/synoinfo.conf"
PIDFILE="/var/run/ddnsd.pid"
DDNS_CONF="/etc/ddns.conf"

if [ "$1" = "start" ]; then
    if [ -x "$DDNS" ]; then
        RunDDNS=`/bin/get_key_value $CONF supportddns`
        if [ "yes" = "$RunDDNS" ]; then
                $DDNS
                /usr/syno/sbin/synoddnsinfo --start-heartbeatd > /dev/null 2>&1
        fi
    else
        echo "$DDNS doesn't exist!"
    fi

    chmod 600 $DDNS_CONF
fi

if [ "$1" = "stop" ]; then
        /usr/bin/killall -9 ddnsd > /dev/null 2>&1
        /bin/rm $PIDFILE > /dev/null 2>&1
        /usr/syno/sbin/synoddnsinfo --stop-heartbeatd > /dev/null 2>&1
        exit 0
fi

if [ "$1" = "restart" ]; then
        $0 stop
        sleep 1
        $0 start
fi
