#!/bin/sh
# Copyright (c) 2000-2010 Synology Inc. All rights reserved.
TEST_SCRIPT_NAME='testupnp'
SYNO_UPNP_TEST_BIN='synoupnptest'
SYNO_UPNP_BIN='synoupnp'
PROGRESS_FILE='/tmp/upnp_test.progress'
ROUTER_PORT_LIST_FILE='router_upnp'

MAX_ADD_COUNT=0
#### argument test #######
usage() {
	echo "Copyright (c) 2000-2010 Synology Inc. All rights reserved."
	echo ""
	echo "Usage: $TEST_SCRIPT_NAME MAX_ADD_NUMUBER "
	echo "   or: $TEST_SCRIPT_NAME OPTION "
	echo ""
	echo "MAX_ADD_NUMBER	Specify the max number of add rules"
	echo "	ex:	$TEST_SCRIPT_NAME 100  (add at most 100 rules)"
	echo "	the valid number is from 3 to 100."
	echo ""
	echo " -h --help	display this message"
	echo " -r --report	directly display info report"
	echo ""
	echo "WARRING:	This script is for internal testing."
}

argument() {
	if [ $# -ne 1 ] || [ $1 == '-h' ] || [ $1 == '--help' ]; then
		usage
		exit 0
	fi

	if [ $1 == '-r' ] || [ $1 == '--report' ]; then
		MAX_ADD_COUNT=0
	elif [[ $1 -ge 3 && $1 -le 100 ]]; then
		MAX_ADD_COUNT=$1
	else
		usage
		exit 0
	fi
}

argument $*

########## FUNCTION ########
report() {
	echo "########## REPORT ############"
	echo "{$BRAND}{$MODEL}{$VERSION}{$TEST_RESULT}{$MAX_UPNP} -- "
	echo ""
	echo "Manufacturer: $BRAND"
	echo "ModelName:    $MODEL"
	echo "ModelNumber:  $VERSION"
	echo ""
	[ -f  $PROGRESS_FILE ] && cat $PROGRESS_FILE
	echo ""
	echo "######## END REPORT ##########"
}

errexit() {
	echo ""
	MAX_UPNP=-1
	$SYNO_UPNP_BIN -l > ROUTER_PORT_LIST_FILE
	report
	echo "ERROR: $1"
	$SYNO_UPNP_TEST_BIN -t
	exit 1
}

waitmessage() {
	var_key=$1
 	sleep 2
	message=`grep $var_key $PROGRESS_FILE | sed "s/${var_key}=//g"`

	while [ "$message" == "processing" ] 
	do
	 	sleep 1
		message=`grep $var_key $PROGRESS_FILE | sed "s/${var_key}=//g"`
	done
	
	sleep 2
	message=`grep $var_key $PROGRESS_FILE | sed "s/${var_key}=//g"`
	if [ "$message" == "finished" -o "$message" == "success" ]; then
		return 0;
	elif [ "$message" == "failed" ]; then
		echo "fail"
		return 1;
	elif [ "$message" == "-1" ]; then
		echo "fail"
		return 1;
	else
		echo "unKown error"
		return 1;
	fi
}
###### START TESTING ##########


##initial
if [ -e $PROGRESS_FILE  ]; then
	rm $PROGRESS_FILE
fi

if [ -e ROUTER_PORT_LIST_FILE  ]; then
	rm ROUTER_PORT_LIST_FILE
fi

if [ $MAX_ADD_COUNT -eq 0 ]; then
	report
	exit 0
fi

######### Model Info ################
MODEL_TMP_FILE='.testmodel'
$SYNO_UPNP_TEST_BIN -i > $MODEL_TMP_FILE ||
{ echo "can't not get router info." && exit 1; }

BRAND=`grep "Manufacturer:" $MODEL_TMP_FILE |sed 's/^Manufacturer: //g'| sed 's/\.$//g'`
MODEL=`grep "ModelName:" $MODEL_TMP_FILE |sed 's/^ModelName: //g'| sed 's/\.$//g'`
VERSION=`grep "ModelNumber:" $MODEL_TMP_FILE |sed 's/^ModelNumber: //g'| sed 's/\.$//g'`

rm $MODEL_TMP_FILE

# check if other upnpd is running
if [ `ps |grep upnpd |wc -l` -gt 2 ]; then
	errexit "other upnp runnig"
fi

TEST_RESULT="upnp_fail"
MAX_UPNP=-1                        

#ADD
echo "$SYNO_UPNP_TEST_BIN -a=$MAX_ADD_COUNT"
$SYNO_UPNP_TEST_BIN -a=$MAX_ADD_COUNT && 
waitmessage upnp_add || 
errexit "$SYNO_UPNP_TEST_BIN -a fail"

#MAX_UPNP
echo "$SYNO_UPNP_TEST_BIN -m"
$SYNO_UPNP_TEST_BIN -m || 
errexit "$SYNO_UPNP_TEST_BIN -m fail"

sleep 1
MAX_UPNP=`grep upnp_max $PROGRESS_FILE | sed 's/upnp_max=//g'`
if [ -z $MAX_UPNP ] || [ -1 -eq $MAX_UPNP ]; then
	errexit "$SYNO_UPNP_TEST_BIN -m fail max_upnp=$MAX_UPNP"
fi

#DELETE
echo "$SYNO_UPNP_TEST_BIN -d"
$SYNO_UPNP_TEST_BIN -d && 
waitmessage upnp_delete || 
errexit "$SYNO_UPNP_TEST_BIN -d fail"
sleep 1

#FAIL TEST
echo "$SYNO_UPNP_TEST_BIN -f"
$SYNO_UPNP_TEST_BIN -f && 
waitmessage upnp_connection_failed   || 
errexit "$SYNO_UPNP_TEST_BIN -f fail"

#MODIFY
echo "$SYNO_UPNP_TEST_BIN -r"
$SYNO_UPNP_TEST_BIN -r && 
waitmessage upnp_readd1 || 
errexit "$SYNO_UPNP_TEST_BIN -r upnp_readd1 fail"

waitmessage upnp_readd2 || errexit "$SYNO_UPNP_TEST_BIN -r upnp_readd2 fail"

#SUCCESS TEST
echo "$SYNO_UPNP_TEST_BIN -s"
$SYNO_UPNP_TEST_BIN -s && 
waitmessage upnp_connection_success || 
errexit "$SYNO_UPNP_TEST_BIN -s fail"

#DELETE
echo "$SYNO_UPNP_TEST_BIN -t"
$SYNO_UPNP_TEST_BIN -t && 
waitmessage upnp_terminal || 
errexit "$SYNO_UPNP_TEST_BIN -t fail"
sleep 1

TEST_RESULT=upnp_ok
report

exit 0
