/*
var synoVolumeUsageData = [
	[ 'volume1', 500 , 200, '20%', '-' ],
	[ 'volume2', 500 , 100, '20%', '-' ],
	[ 'volume3', 500 , 300, '20%', '-' ]
];
var synoVolumeUsageDataHistory = {
	'volume1' : [
		[ 1353314537, 80 ],
		[ 1353314538, 20 ],
		[ 1353314539, 30 ]
	],
	'volume2' : [
		[ 1353314537, 20 ],
		[ 1353314538, 50 ],
		[ 1353314539, 40 ]
	],
	'volume3' : [
		[ 1353314537, 10 ],
		[ 1353314538, 80 ],
		[ 1353314539, 90 ]
	]
};
*/
var VolumeUsageColorHash = {};


function VolumeUsage()
{
	var container;
	if(typeof synoVolumeUsageData === "undefined" || synoVolumeUsageData.length === 0) {
		NoDataSet('volume_usage_nodata');
		return;
	}
	VolumeUsageTable();
	if(typeof synoVolumeUsageDataHistory === "undefined") {
		container = document.getElementById("volume_usage_line");
		if(container !== undefined) {
			container.style.height = "1px";
		}
	} else {
		VolumeUsageLine( {} );
	}
}

function VolumeUsageLine(volume_list)
{
  var container = document.getElementById("volume_usage_line");
  var myColor = [], key, i, graph;

  var lineData = [];
  
  if(typeof synoVolumeUsageDataHistory === "undefined") {
	return;
  }
  for ( i in synoVolumeUsageDataHistory) {
	  if(volume_list[i] === undefined ) {
		  continue;
	  }
	  lineData.push(synoVolumeUsageDataHistory[i] );
	  myColor.push(VolumeUsageColorHash[i]);
  }

  /*
  var
    d1 = [[0, 3], [4, 8], [8, 5], [9, 13]], // First data series
    d2 = [],                                // Second data series
    i, graph;


  // Generate first data set
  for (i = 0; i < 14; i += 0.5) {
    d2.push([i, Math.sin(i)]);
  }
  */

  // Draw Graph
  //graph = Flotr.draw(container, [ d1, d2 ], {
  graph = Flotr.draw(container, lineData,  {
    yaxis: {
		max: 100,
		min: 0,
	  tickFormatter: function (y) {
		  return y + '%';
      }
    }, 
    xaxis: {
      //minorTickFreq: 1,
	  tickFormatter: function (x) {
		  return new Date(x*1000).toDateString();
      }
    }, 
	colors: myColor,
	mouse : { 
		track : true,
		trackAll: true,
		trackFormatter: function(x) {
			return parseInt(x.y, 10) + '%';
		}
	},
    grid: {
	  verticalLines : true,
      horizontalLines : true
    }
  });

}

function VolumeUsageColor(val)
{
	var str;
	if(typeof synoVolumeUsageDataHistory === "undefined") {
		str = VolumeId2Name(val);
	} else {
		str = "<table><tr><td width=12 height=10 bgcolor='" + VolumeUsageColorHash[val] +
			"'>&nbsp;</td><td>&nbsp;" + VolumeId2Name(val) + "</td></tr></table>";
	}

	return str;
}

function VolumeUsagePickColor()
{
	var i=0, item;

	if(typeof synoVolumeUsageDataHistory === "undefined") {
		return;
	}

	for (item in synoVolumeUsageDataHistory) {
		pickColor(VolumeUsageColorHash, item, i, synoVolumeUsageData.length);
		i++;
	}
}


function VolumeUsageTable()
{
	var totalWidth=930;
	var widthHistory=930;
	var firstColumnWidth=300;
	var smCheck = {};
	var gridConfig = {};
	var gridColumn = [];
	var blHistory = false;
	var i;

	if(typeof synoVolumeUsageDataHistory !== "undefined") {
		blHistory = true;
	}

	Ext.QuickTips.init();

	VolumeUsagePickColor();

    // NOTE: This is an example showing simple state management. During development,
    // it is generally best to disable state management as dynamically-generated ids
    // can change across page loads, leading to unpredictable results.  The developer
    // should ensure that stable state ids are set for stateful components in real apps.
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

	var volumeUsage = [];
	for( i=0; i<synoVolumeUsageData.length; i++) {
		var tmp = [ synoVolumeUsageData[i][0], synoVolumeUsageData[i][1] + synoVolumeUsageData[i][2],
			synoVolumeUsageData[i][3], synoVolumeUsageData[i][4] ];
		volumeUsage.push(tmp);
	}


    var store = new Ext.data.ArrayStore({
        fields: [
           {name: 'Volume'},
           {name: 'Size'},
           {name: 'Used'},
           {name: 'Day'}
        ]
    });


    // manually load local data
    store.loadData(volumeUsage);

	if(blHistory) {
		firstColumnWidth=280;
	}

	if(blHistory) {
		smCheck = new Ext.grid.CheckboxSelectionModel( {
			store: store,
			selectVolume: new Array(),
			checkOnly : true,
			listeners : {
				rowselect: function(obj, rowIndex, e) {
					var rec = grid.store.getAt(rowIndex);
					obj.selectVolume[rec.data.Volume] = {};
					VolumeUsageLine(obj.selectVolume);
				},
				rowdeselect: function(obj, rowIndex, e) {
					var rec = grid.store.getAt(rowIndex);
					delete obj.selectVolume[rec.data.Volume];
					VolumeUsageLine(obj.selectVolume);
				},
				scope: this
			}
		});
	}

	gridColumn = [
			smCheck,
			{
				id       : 'Volume',
				header   : _T('report', 'reportUI_title_volume'),
				width    : totalWidth*firstColumnWidth/widthHistory,
				renderer : VolumeUsageColor,
				sortable : true,
				dataIndex: 'Volume',
				tooltip  : _T('report', 'reportUI_title_volume'),
				css: 'font-weight: bold;'
			},
			{
				id       : 'Size',
				header   : _T('common', 'size'),
				width    : totalWidth*230/widthHistory,
				sortable : true,
				tooltip  : _T('common', 'size'),
				renderer : SizeUnit,
				dataIndex: 'Size'
			},
			{
				header   : _T('report', 'reportUI_title_used'),
				width    : totalWidth*200/widthHistory,
				sortable : true,
				tooltip  : _T('report', 'reportUI_title_used'),
				renderer : SizePercent,
				dataIndex: 'Used'
			},
			{
				header   : _T('report', 'reportUI_title_day_to_full'),
				width    : totalWidth*200/widthHistory,
				sortable : true,
				tooltip  : _T('report', 'reportUI_title_day_to_full'),
				renderer : DayToFull,
				dataIndex: 'Day'
			}];

	var GridRender = Ext.emptyFn;
	if(blHistory) {
		GridRender = function(grid) {
			for(i=0; i<5; i++) {
				grid.getSelectionModel().selectRow(i, true, false); 
			}
		};
	}

    gridConfig = {
        border: false,
        store: store,
	sm: smCheck,
	enableColumnResize: false,
	enableHdMenu: false,
	enableColumnHide: false,
	enableColumnMove: false,
	viewConfig: GridViewConfig,
        columns: gridColumn,
        plugins: [ new GridPanelPlugin(4) ],
        stripeRows: true,
        width: totalWidth,
		listeners: {
			afterrender: function (grid) { GridRender.createDelegate(this, [ grid ]).defer(1000); }
		}
    };

	if(!blHistory) {
		gridColumn.shift();
		delete gridConfig.sm;
	} 
	
	// create the Grid
    var grid = new Ext.grid.GridPanel( gridConfig );

    // render the grid to the specified div in the page
    grid.render('volume_usage_table');
}
