#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

SFTPD='/usr/syno/sbin/sftpd'
SFTPPidFile='/var/run/sftpd.pid'
RM=/bin/rm
CP=/bin/cp
SSHDName="sshd"
SFTPDName="sftpd"
RunSFTP=`/bin/get_key_value /etc/synoinfo.conf runsftp`
Port=`/bin/get_key_value /etc/synoinfo.conf sftpPort`

. /etc.defaults/rc.subr
. /usr/syno/etc.defaults/rc.ssh.subr

StartSSHForSFTP()
{
    # gen-key and start sshd in background mode
    IsPidRunning ${SSHPidFile}
    if [ $? = 1 ]; then
	    ${SSHDUtils} --register ${ReferKeySFTP} ${ReferProcSFTP}
	    echo "Another SSH is starting. Skip..."
	    if [ ! -f $SFTPPidFile ]; then
		$CP $SSHPidFile $SFTPPidFile
	    fi
	    exit 0
    fi

    GenerateSSHKey
    
    if [ -x "$SSHD" ]; then
	    echo "Start SSH Server for SFTP....."
	    $SSHD
	    ${SSHDUtils} --register ${ReferKeySFTP} ${ReferProcSFTP}
	    if [ ! -f $SFTPPidFile ]; then
		$CP $SSHPidFile $SFTPPidFile
	    fi
    else
	    echo "$SSHD is not executable."
    fi
}

StartSFTP()
{
    if [ -x "${SFTPD}" ]; then
	    echo "Start SFTP Server....."
	    ${SFTPD} -p ${Port}
    else
	    echo "${SFTPD} is not executable."
    fi
}

IsSFTPDAlive()
{
    IsPidRunning ${SFTPPidFile}
    if [ $? -eq 1 ] ; then
	    return $LSB_STAT_RUNNING
    else
	    return $LSB_STAT_NOT_RUNNING
    fi
}

case "$1" in

stop)
	echo "Stop SFTP..."
	# for SFTP using SSH port
	${SSHDUtils} --unregister_kill ${ReferKeySFTP}

	# for SFTP using Independent SFTP port
	killall sftpd

	#rm sftpd pidfile
	if [ -f $SFTPPidFile ]; then
		$RM $SFTPPidFile
	fi
	;;

start)	
	if [ "xyes" != "x${SupportSSH}" ]; then
	    echo "SSH is not supported. Skip..."
	    exit 0
	elif [ "xyes" != "x${RunSFTP}" ]; then
	    echo "SFTP is not enabled. Skip running SFTP"
	    exit 0
	fi

	if [ -z ${Port} ]; then
	    StartSSHForSFTP
	elif [ "x${Port}" = "x${SSHDefaultPort}" ]; then
	    StartSSHForSFTP
	else
	    StartSFTP
	fi
	;;
	
restart)
	$0 stop
	sleep 1
	$0 start
	;;
status)
	if [ "yes" = ${RunSFTP} ]; then
	    if [ ${Port} -eq ${SSHDefaultPort} ]; then
		lsb_status $SSHDName $SFTPPidFile
	    else
		lsb_status $SFTPDName $SFTPPidFile
	    fi
	else
	    return $LSB_STAT_NOT_RUNNING
	fi
	;;
*)
	echo "usage: $0 { start | stop | restart | status}" >&2
        exit 1
        ;;
	                        
esac
