#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

RunSSH=`/bin/get_key_value /etc/synoinfo.conf runssh`

. /etc.defaults/rc.subr
. /usr/syno/etc.defaults/rc.ssh.subr

case "$1" in

stop)
	echo "Stop SSH..."
	${SSHDUtils} --unregister_kill ${ReferKeyShell}
	;;

start)	
	# gen-key and start sshd in background mode
	IsPidRunning ${SSHPidFile}
	if [ $? = 1 ]; then
		echo "Another SSH is starting. Skip..."
		${SSHDUtils} --register ${ReferKeyShell} ${ReferProcShell}
		exit 0
	fi

	if [ "yes" = "$SupportSSH" ]; then
		/bin/sh /usr/syno/etc.defaults/rc.ssh > /dev/null 2>&1 &
		echo "Start SSH..."
	fi
	;;
	
restart)
	$0 stop
	sleep 1
	$0 start
	;;	
status)
	if [ "yes" = ${RunSSH} ]; then
	    IsSSHDAlive
	    return $?
	else
	    return $LSB_STAT_NOT_RUNNING
	fi
	;;
*)
	echo "usage: $0 { start | stop | restart | status}" >&2
        exit 1
        ;;
	                        
esac
