#!/bin/sh
# Copyright (c) 2003-2011 Synology Inc. All rights reserved.

SYNOINFO_CONF="/etc/synoinfo.conf"

case $1 in
"start")
	NeedReindex=0

	echo "Update media type table where type id = 0 to test db existence"
	su -l admin -c "/usr/syno/pgsql/bin/psql mediaserver -c \"select 1 from music limit 1\""
	Ret=$?
	if [ $Ret = 2 ]; then
		su -l admin -c "/usr/syno/pgsql/bin/createdb mediaserver"
		if [ $? != 0 ]; then
			echo "Failed to create database"
			exit
		fi
		Script="/usr/syno/synoindex/sql/mediaserver.pgsql"
		Ret=1
	fi

	if [ $Ret = 1 ]; then
		su -l admin -c "/usr/syno/pgsql/bin/psql mediaserver < $Script"
		if [ $? != 0 ]; then
			echo "Failed to initial media database"
			exit
		fi

		NeedReindex=1
	fi

	upgrades=`find /usr/syno/synoindex/sql/upgrade -name "*.sh" | sort`
	for ThisArg in $upgrades;
	do
		$ThisArg
		Ret=$?
		if [ $Ret = 1 ]; then
			NeedReindex=1
		fi
	done

	if [ $NeedReindex = 1 ]; then
		/usr/syno/bin/synoindex -R all
	fi

	;;
*)
	echo "Usage: $0 start"
	;;
esac
