BEGIN;

CREATE TABLE music
(
  id serial NOT NULL,
  path text NOT NULL,
  title text NOT NULL,
  filesize int8 NOT NULL DEFAULT 0,
  album text,
  artist text,
  album_artist text,
  composer text,
  comment text,
  year int4,
  genre varchar(128),
  frequency int4,
  bitrate int4,
  duration int4,
  channel int4,
  track int4,
  disc int4,
  covercount int4,
  date timestamp,
  mdate timestamp,
  fs_uuid text,
  fs_online boolean DEFAULT TRUE,
  CONSTRAINT music_pkey PRIMARY KEY (id)
)
WITHOUT OIDS;
CREATE INDEX music_album_idx ON music USING btree (album);
CREATE INDEX music_artist_idx ON music USING btree (artist);
CREATE INDEX music_album_artist_idx ON music USING btree (album_artist);
CREATE INDEX music_year_idx ON music USING btree ("year" int4_ops);
CREATE INDEX music_disc_idx ON music USING btree (disc int4_ops);
CREATE INDEX music_track_idx ON music USING btree (track int4_ops);
CREATE INDEX music_genre_idx ON music USING btree (genre);
CREATE INDEX music_composer_idx ON music USING btree (composer);
CREATE INDEX music_title_idx ON music USING btree (title);
CREATE INDEX music_date_idx ON music USING btree (date);
CREATE INDEX music_mdate_idx ON music USING btree (mdate);
CREATE UNIQUE INDEX music_path_idx ON music USING btree (path);

CREATE TABLE playlist
(
  id serial NOT NULL,
  path text NOT NULL,
  title text NOT NULL,
  filesize int8 NOT NULL DEFAULT 0,
  album text,
  song_count int4 NOT NULL DEFAULT 0,
  date timestamp,
  mdate timestamp,
  fs_uuid text,
  fs_online boolean DEFAULT TRUE,
  CONSTRAINT playlist_pkey PRIMARY KEY (id)
)
WITHOUT OIDS;
CREATE UNIQUE INDEX playlist_path_idx ON playlist USING btree (path);

CREATE TABLE photo
(
  id serial NOT NULL,
  path text NOT NULL,
  title text NOT NULL,
  filesize int8 NOT NULL DEFAULT 0,
  album text,
  resolutionx int4,
  resolutiony int4,
  camera_make varchar(100),
  camera_model varchar(100),
  exposure varchar(20),
  aperture varchar(20),
  iso int4,
  date timestamp,
  timetaken timestamp,
  mdate timestamp,
  fs_uuid text,
  fs_online boolean DEFAULT TRUE,
  CONSTRAINT photo_pkey PRIMARY KEY (id)
)
WITHOUT OIDS;
CREATE INDEX photo_title_idx ON photo USING btree (title);
CREATE INDEX photo_date_idx ON photo USING btree (date);
CREATE INDEX photo_timetaken_idx ON photo USING btree (timetaken);
CREATE INDEX photo_mdate_idx ON photo USING btree (mdate);
CREATE UNIQUE INDEX photo_path_idx ON photo USING btree (path);

CREATE TABLE video
(
  id serial NOT NULL,
  path text NOT NULL,
  title text NOT NULL,
  filesize int8 NOT NULL DEFAULT 0,
  album text,
  container_type text NOT NULL,
  video_codec text,
  frame_bitrate int4,
  frame_rate_num int4,
  frame_rate_den int4,
  video_bitrate int4,
  video_profile int4,
  video_level int4,
  resolutionX int4,
  resolutionY int4,
  audio_codec text,
  audio_bitrate int4,
  frequency int4,
  channel int4,
  duration int4,
  date timestamp,
  mdate timestamp,
  fs_uuid text,
  fs_online boolean DEFAULT TRUE,
  CONSTRAINT video_pkey PRIMARY KEY (id)
)
WITHOUT OIDS;
CREATE INDEX video_title_idx ON video USING btree (title);
CREATE INDEX video_date_idx ON video USING btree (date);
CREATE INDEX video_mdate_idx ON video USING btree (mdate);
CREATE UNIQUE INDEX video_path_idx ON video USING btree (path);

CREATE TABLE directory
(
  id serial NOT NULL,
  path text NOT NULL,
  title text,
  date timestamp,
  mdate timestamp,
  fs_uuid text,
  fs_online boolean DEFAULT TRUE,
  CONSTRAINT directory_pkey PRIMARY KEY (id),
  CONSTRAINT directory_path_key UNIQUE (path)
)
WITHOUT OIDS;
CREATE UNIQUE INDEX directory_path_idx ON directory USING btree (path);

CREATE TABLE video_convert (
 video_path text NOT NULL,
 convert_file_path text NOT NULL,
 resolutionx int4 DEFAULT NULL,
 resolutiony int4 DEFAULT NULL,
 container_type text NOT NULL,
 video_bitrate int4 DEFAULT NULL,
 vcodec text DEFAULT NULL,
 video_profile int4 DEFAULT NULL,
 video_level int4 DEFAULT NULL,
 acodec text DEFAULT NULL,
 audio_bitrate int4 DEFAULT NULL,
 audio_frequency int4 DEFAULT NULL,
 audio_channel int4 DEFAULT NULL,
 convert_type text NOT NULL,
 fs_online boolean DEFAULT TRUE,
 CONSTRAINT video_convert_pkey PRIMARY KEY (convert_file_path),
 CONSTRAINT video_convert_fk1 FOREIGN KEY (video_path) REFERENCES video (path) ON DELETE CASCADE ON UPDATE CASCADE
)
WITHOUT OIDS;
CREATE INDEX video_convert_convert_type_idx ON video_convert USING btree (convert_type);
CREATE INDEX video_convert_video_path_idx ON video_convert USING btree (video_path);

COMMIT;
