#!/bin/sh
# Copyright (c) 2000-2013 Synology Inc. All rights reserved.


syslog() {
	local ret=$?
	logger -p user.err -t $(basename $0) "$@"
	return $ret
}
syno_disable_HD204UI()
{
	for hdd in /sys/block/sd*/device/model /sys/block/usb*/device/model /sys/block/sas*/device/model; do
		if [ "x`cat $hdd 2>/dev/null`" = "xHD204UI" -a -f "${hdd//model/syno_disk_serial}" ]; then
			if cat ${hdd//model/syno_disk_serial} | cut -c8-9 | egrep -q "Z[0-9AB]"; then
				tmp=${hdd#/sys/block/}
				dev=${tmp%/device/model}
				/usr/syno/bin/hdparm -W 0 /dev/$dev
			fi
		fi
	done
}

is_key_value_yes()
{
	if [ "x`/bin/get_key_value /etc/synoinfo.conf $1`" == "xyes" ]; then
		true
	else
		false
	fi
}

is_package_installed()
{
	local packageFile="$1"
	local packageName=`echo $packageFile | sed -n 's,^.*/\([a-zA-Z]\+\).*$,\1,p'`

	if [ -d "/var/packages/$packageName" ]; then
		true
	else
		false
	fi
}

# Is packge $3 built-in package for dsm $1.$2?
#
# Example1, Is MailServer in dsm 4.1 will return 0
# Example2, Is Perl in dsm 4.1 will return 1
#
# PROTO TYPE:
#         is_in_dsm major_version minor_version package_name
is_in_dsm()
{
	local package_4_1_list="MailServer"
	local package_4_2_list="MailServer Perl"
	local packageName=`echo $3 | sed -n 's,^.*/\([a-zA-Z]\+\).*$,\1,p'`
	local package_list=

	if [ "x$1" = "x4" ]; then
		if [ "x$2" = "x1" ]; then
			package_list=${package_4_1_list}
		elif [ "x$2" = "x2" ]; then
			package_list=${package_4_2_list}
		fi
	else
		false
	fi

	for i in ${package_list}
	do
		if [ "x$packageName" = "x${i}" ]; then
			return 0
		fi
	done
	return 1
}

list_packages_need_enable()
{
	local packages=""

	if [ -d /var/packages/MailServer/ ]; then
		# if MailServer package is exist, we need check it enable key
		if [ -e /var/packages/MailServer/enabled ]; then
			packages="$packages MailServer"
		fi
	else
		# in old DSM, check mail server built-in keys in synoinfo
		for key in smtp imap imaps pop3 pop3s; do
			if is_key_value_yes "${key}_enabled" ; then
				packages="$packages MailServer"
				break
			fi
		done
	fi


	echo $packages
}

install_builtin_packages() {
	local package_dir=$1
	local synopkg=/usr/syno/bin/synopkg
	local packagesNeedEnable=$(list_packages_need_enable)
	local old_major=`/bin/get_key_value /.old_patch_info/VERSION majorversion`
	local old_minor=`/bin/get_key_value /.old_patch_info/VERSION minorversion`
	local HAMANAGER="HAManager"

	[ -d "$package_dir" ] || return 1

	# if no "/.old_patch_info" (new installation), skip installation of builtin package
	[ -f "/.old_patch_info/VERSION" ] || return 1

	# [4.2 Beta fix]
	# TODO: Should consider dependcy when install by synopkg
	# These code will install perl and remove perl package from built-in package folder.
	##################
	for i in $package_dir/*; do
		local packageName=`echo $i | sed -n 's,^.*/\([a-zA-Z]\+\).*$,\1,p'`

		if [ "Perl" = "$packageName" ]; then
			if $(is_in_dsm "${old_major}" "${old_minor}" "$i"); then
				if is_package_installed "$i"; then
					syslog "install package: $i"
					$synopkg install "$i"
				fi
			else
				syslog "install package: $i"
				$synopkg install "$i"
			fi
			rm $package_dir/Perl-*
			syslog "start package: Perl"
			$synopkg start "Perl"
		fi
	done
	##################
	for i in $package_dir/*; do
		if `echo "$i" | grep -q "$HAMANAGER"`; then
			if is_package_installed "$i"; then
				syslog "install package: $i"
				$synopkg install "$i"
			fi
			continue
		fi
		# if user remove this package in old dsm, we should not install again.
		if $(is_in_dsm "${old_major}" "${old_minor}" "$i"); then
			if is_package_installed "$i"; then
				syslog "install package: $i"
				$synopkg install "$i"
			fi
		else
			syslog "install package: $i"
			$synopkg install "$i"
		fi
	done

	# [WORKAROUND]: fix service port config is not loaded while starting firewall
	# restart firewall here to fix it temporarily
	/usr/syno/etc/rc.d/S01iptables.sh restart

	for p in $packagesNeedEnable; do
		syslog "start package: $p"
		$synopkg start "$p"
	done
}

dump_sas_disk_map()
{
	supportSAS=`/bin/get_key_value /etc.defaults/synoinfo.conf supportsas`
	if [ "xyes" == "x${supportSAS}" -o "xYES" == "x${supportSAS}" ]; then
		sleep 15
		/usr/syno/bin/synoenc --dump_enc_disk /tmp/sasdiskmaps
		cat /tmp/sasdiskmaps >> /var/log/messages
	fi
}

# disable write cache of HD204UI
if [ x`/bin/get_key_value /etc/synoinfo.conf allow_HD204UI` != "xyes" ]; then
	syno_disable_HD204UI
fi

# the file was touched in /etc/rc
if [ -f /tmp/.ImproperShutdown ]; then
	/usr/syno/bin/synologset1 sys warn 0x11100001
	/usr/syno/bin/synonotify ImproperShutdown
	rm -f /tmp/.ImproperShutdown
fi

# the file was touched by group installer for full system burn-in
if [ -f /.fullburnin.sh ]; then
	lan=`get_key_value /etc.defaults/synoinfo.conf maxlanport`
	[ "$lan" != "" ] || lan=1

	while [ $lan -ge 1 ];
	do
		/.fullburnin.sh $lan &
		lan=`expr $lan - 1`
		sleep 20
	done
fi

if [ "$1" = "start" ]; then
	/bin/kill -USR1 `cat /var/run/findhostd.pid`
	
	if [ -x /usr/syno/bin/synofstool ]; then
		/usr/syno/bin/synofstool --dump-fscache &
	fi

	#Create volume for network install
	if [ -f "/.assistant_install_create_vol" ]; then
		/usr/syno/bin/volumetool --create-for-install
		rm -f /.assistant_install_create_vol
	fi

	if [ -d /.SynoUpgradePackages ]; then
		install_builtin_packages /.SynoUpgradePackages
		rm -rf /.SynoUpgradePackages
	fi

	#Remove updater and version files for first-bootup of upgrade
	rm -f /.updater
	rm -f /var/.UpgradeBootup
fi


dump_sas_disk_map &
