#!/bin/sh

action=$1
params=$2

log() {
	false && logger -p user.err -t "$(basename $0)" "$@"
}

log "action: $action"
log "params: $params"

case "$action" in
enum_domain)
# this action is not implement now. we use the session name in
# /etc.default/ddns_provider.conf instead
	echo "able.or.kr"
	;;
add_user)
	echo "bad"
	;;
add_host)
# please implement add_host action here. you can use 'curl' or 'wget'
# to send HTTP request to your server
	serverurl=$( echo $params | cut -d '?' -f1 )
	postdata=$( echo $params | cut -d '?' -f2 )

	log "/usr/syno/bin/curl -d $postdata $serverurl"

	text=$( /usr/syno/bin/curl -d "$postdata" "$serverurl" )
	ret=$?

	log "curl return: $ret"
	log "response text: $text"

	case "$ret" in
		0)
		        response=$( echo $text | cut -d '
' -f2 );;
		1|2|3|4|23|26|33|34|35)
			response="sysfail";;
		5|6)
			response="dnsfail";;
		7|22|28)
			response="connfail";;
		*)
			response="connfail";;
	esac
        
        log "response: $response"
	printf "%s" "$response"
	;;
*)
	echo "bad"
esac

# these are all response for DSM ddns register
#     dup_hostname dup_user dup_email dup_all badauth bad good connfail

