#!/bin/sh
#set -x
PIDFILE=/var/run/snmpd.pid
SNMPD=/usr/syno/sbin/snmpd
SNMPDNAME=snmpd
KILLALL=/usr/bin/killall
KILL=/bin/kill
ECHO=/bin/echo
CAT=/bin/cat
SLEEP=/bin/sleep
PIDOF=/bin/pidof
CONFFILE=/usr/syno/etc/snmpd.conf
ipv4only=`/bin/get_key_value /etc.defaults/synoinfo.conf ipv4only`

CheckPidExist()
{
	Pid=`$CAT $PIDFILE > /dev/null 2>&1`
	if [ "x$Pid" != "x" -a -d "/proc/$Pid" ]; then
		return 1
	fi
	return 0
}

StartSnmpd()
{
	CheckPidExist
	Ret1=$?

	if [ -x $SNMPD -a $Ret1 -eq 0 ]; then
		$ECHO ' Starting Snmpd'
		if [ -n "${ipv4only}" -a "yes" = "${ipv4only}" ]; then
			$SNMPD -Ln -c $CONFFILE -p $PIDFILE udp:161,tcp:161
		else
			$SNMPD -Ln -c $CONFFILE -p $PIDFILE udp:161,udp6:161,tcp:161,tcp6:161
		fi
		return 0
	fi

	return 0
}

StopSnmpd()
{
	$ECHO ' Stoping snmpd'
	$KILLALL $SNMPDNAME > /dev/null 2>&1
	$SLEEP 1

	return 0
}

case $1 in
	"start")
		StartSnmpd
		;;
	"stop")
		StopSnmpd
		;;
	"restart")
		StopSnmpd
		StartSnmpd
		;;
	*)
		echo "Usage: $0 start|stop|restart"
		;;
esac

