#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

ETC_TEMPLATE="/usr/syno/etc/synovpnclient/template"
DEF_TEMPLATE="/usr/syno/etc.defaults/synovpnclient/template"

VPNC_CONNECTING="/usr/syno/etc/synovpnclient/vpnc_connecting"
IP_DOWN="/usr/syno/etc.defaults/synovpnclient/scripts/ip-down"

VPNC_CURR="/tmp/vpnc_current"
VPNC_SHUTDOWN="/tmp/vpnc_shutdown"

start() {
	# check if templates need to upgrade
	RetDiff=`/usr/bin/diff -q ${ETC_TEMPLATE} ${DEF_TEMPLATE} | wc -l`
	if [ ${RetDiff} -ne 0 ]; then
		echo "upgrade vpn profiles..."
		/usr/syno/bin/synovpnc update_conf
		#sync templates
		rm -rf ${ETC_TEMPLATE}
		cp -R ${DEF_TEMPLATE} ${ETC_TEMPLATE}
	fi

	# auto reconnect
	if [ -e "${VPNC_CONNECTING}" ]; then
		/usr/bin/killall synovpnc 2>/dev/null
		eval `/bin/grep '^proto=' ${VPNC_CONNECTING}`
		eval `/bin/grep '^conf_name=' ${VPNC_CONNECTING}`
		/usr/syno/bin/synovpnc reconnect --protocol=${proto} --name=${conf_name} --keepfile
		if [ $? != 0 ]; then
			/usr/syno/bin/synovpnc reconnect --protocol=${proto} --name=${conf_name} --retry=3 --interval=30 &
		fi
	fi
}

# kill the process of vpn client
# ip-down will do auto-reconnect
stop() {
	/usr/bin/killall synovpnc 2>/dev/null
	if [ -e "${VPNC_CURR}" ]; then
		eval `/bin/grep '^conf_id=' ${VPNC_CURR}`
		eval `/bin/grep '^proto=' ${VPNC_CURR}`
		if [ "openvpn" = "${proto}" ]; then
			${IP_DOWN}
                        /usr/bin/killall openvpn 2>/dev/null
		else
			#pptp
                        pid=`cat /var/run/ppp-vpn_${conf_id}.pid | head -1`
                        # kill pptp will signal ip-down script
                        /bin/kill ${pid} 2>/dev/null
		fi
	fi
}

# generate "vpnc_shutdown" for ip-down to create "vpnc_connecting" but not do auto-reconnect
shutdown() {
	if [ -e "${VPNC_CURR}" ]; then
		/bin/touch ${VPNC_SHUTDOWN}
		stop
	fi
}

disconnect() {
	/usr/syno/bin/synovpnc kill_client
}

case $1 in
start)
        start
        ;;
stop)
        stop
        ;;
shutdown)
        shutdown
        ;;
disconnect)
        disconnect
        ;;
*)
        echo "Usages: $0 [start|stop|shutdown|disconnect]"
        ;;
esac
