<?php
/* Copyright (c) 2010 Synology Inc. All rights reserved. */
class AppIndexConf {
	var $confpath;
	var $jsonObj;
	var $translator;

	function AppIndexConf($confpath) {
		$this->confpath = $confpath;
	}
	private function translate($s) {
		if($this->translator) {
			$s = $this->translator->getString($s);
		}
		return $s;
	}
	function getConfPath() {
		return $this->confpath;
	}
	function getModuleCount() {
		$cnt = 0;
		if(is_array($this->jsonObj['modules'])) {
			$cnt = count($this->jsonObj['modules']);
		}
		return $cnt;
	}
	function getModuleConf($idx) {
		if(is_array($this->jsonObj['modules'])) {
			$cnt = count($this->jsonObj['modules']);
			if($idx < $cnt) {
				$obj = array();
				$conf = $this->jsonObj['modules'][$idx];
				$obj['title'] = $this->getString($conf, 'title');
				$obj['desc'] = $this->getString($conf, 'desc');
				$obj['keywords'] = $this->getArray($conf, 'keywords');
				$obj['help'] = $conf['help'];
				$obj['params'] = $conf['params'];
				return $obj;
			}
		}
		return NULL;
		
	}
	function getStringSet() {
		return $this->jsonObj['stringset'];
	}
	function getHelpSet() {
		return $this->jsonObj['helpset'];
	}
	function getHelp() {
		return $this->jsonObj['help'];
	}
	function getAppClass() {
		return $this->jsonObj['app'];
	}
	function getAppDesc() {
		return $this->getString($this->jsonObj, 'desc');
	}
	
	private function getString($obj, $key) {
		$val = $obj[$key];
		return $this->translate($val);

	}
	private function getArray($obj, $key) {
		$ret = array();
		$arr = $obj[$key];
		if(is_array($arr)) {
			foreach($arr as $word) {
				$ret[] = $this->translate($word);
			}
		}
		return $ret;

	}
	function getKeywords() {
		return $this->getArray($this->jsonObj, 'keywords');
	}
	function getAppTitle() {
		return $this->translate($this->jsonObj['title']);
	}
	function setTranslator($bundle) {
		$this->translator = $bundle;
	}
	function loadObject($obj) {
		$this->jsonObj = $obj;
	}
	function load() {
		$ret = FALSE;
		$jsonData = file_get_contents($this->confpath);
		if($jsonData != FALSE) {
			$this->jsonObj = json_decode($jsonData, TRUE);
			if(!is_null($this->jsonObj)) {
				$ret = TRUE;
				//var_dump($this->jsonObj);
			}
		}
		return $ret;
	}

}


?>
